<?php
/**--------------------------------------
 * @package     ruxin_news - Ruxin News
 * @copyright   Copyright (C) 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 * ---------------------------------------**/
defined('_JEXEC') or die;

$show_lead_image = $params->get('show_lead_thumbnail', 1);
$lead_thumbnail_float = $params->get('lead_image_align', 'none');

$lead_thumbnail_width = $params->get('lead_thumbnail_width', '600');
$lead_thumbnail_height = $params->get('lead_thumbnail_height', '250');

$lead_column = $params->get('lead_column', 1);
$lead_items = array_slice($list, 0, $lead_count);
$lead_text_type = $params->get('lead_text_type', 'news_on_image');

if (!$show_lead_image) $lead_text_type = 'news_normal';

$lead_title_size = $params->get('lead_title_size', 18);

$show_lead_title = $params->get('show_lead_title', 1);
$show_lead_intro = $params->get('show_lead_introtext', 0);
$lead_title_limit = $params->get('lead_title_limit', 120);
$lead_introtext_limit = $params->get('lead_introtext_limit', 120);

$show_lead_date = $params->get('show_lead_date', 'LC1');
$show_lead_hits = $params->get('show_lead_hits', 0);
$show_lead_cat = $params->get('show_lead_cat', 0);
$lead_cat_top = $params->get('lead_cat_top', 0);

$show_lead_author = $params->get('show_lead_author', 0);

$lead_title_weight = $params->get('lead_title_weight', 400);
$lead_image_count = 0;
$lead_width = $params->get('lead_width', '50%');

$lead_text_center = $params->get('lead_text_center', 0);

$lead_date_icon = ($lead_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/date.png" : JURI::root()."modules/mod_ruxin_news/includes/images/date-dark.png";
$lead_hits_icon = ($lead_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/hits.png" : JURI::root()."modules/mod_ruxin_news/includes/images/hits-dark.png";
$lead_author_icon = ($lead_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/author.png" : JURI::root()."modules/mod_ruxin_news/includes/images/author-dark.png";

$lead_show_read_more = $params->get('lead_show_read_more', 0);
$lead_read_more_text = $params->get('lead_read_more_text', 'Read More...');
$lead_read_more_color = $params->get('lead_read_more_color', '#c7c7c7');
$lead_read_more_font_size = $params->get('lead_read_more_font_size', '13px');

// Extra Fields
$leading_show_field = $params->get('leading_show_field', 0);
$leading_field_position = $params->get('leading_field_position', "before_title");
$leading_field_number = $params->get('leading_field_number', 0);
$leading_field_character_limit = $params->get('leading_field_character_limit', 80);
$leading_field_text = $params->get('leading_field_text', "");
?>

<div class="news-leading">
    <?php foreach (array_chunk($lead_items, $lead_column) as $posts_row) { ?>

        <div class="news-row">

            <?php foreach ($posts_row as $key => $item){ ?>

                <div class="ruxin-news-col-<?php echo $lead_column; ?>">
                    <div class="news-item">
                        <?php if ($show_lead_image) { ?>

                        <a href="<?php echo $item->link; ?>" class="title" itemprop="url">
                            <?php if ($lead_text_type == "news_on_image") { ?>
                                <div class="<?php echo $image_hover_effect; ?>">
                                    <img class="leading_news_image" src="<?php echo $images[$lead_image_count]['lead_thumb']; ?>" alt="<?php echo $item->title; ?>" style="height: <?php echo $lead_thumbnail_height;?>px;"/>
								</div>
                            <?php } else if ($lead_thumbnail_float == "left") { ?>
                                <img class="leading_news_image float_left" src="<?php echo $images[$lead_image_count]['lead_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $lead_thumbnail_width;?>px; height: <?php echo $lead_thumbnail_height;?>px;"/>
							<?php } else if ($lead_thumbnail_float == "right") { ?>
                                <img class="leading_news_image float_right" src="<?php echo $images[$lead_image_count]['lead_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $lead_thumbnail_width;?>px; height: <?php echo $lead_thumbnail_height;?>px;"/>
							<?php } else { ?>
								<img class="leading_news_image float_none" src="<?php echo $images[$lead_image_count]['lead_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $lead_thumbnail_width;?>px; height: <?php echo $lead_thumbnail_height;?>px;"/>
									
							<?php } ?>
						</a>
							<!-- Show Category -->
							<?php if ($show_lead_cat && $lead_cat_top) { ?>
								<div class = "lead_category_top lead_catid_<?php echo $item->catid; ?>">
									<a href="<?php echo $item->categoryLink; ?>">
										<?php echo $item->category_title; ?>
									</a>
								</div>
							<?php } ?>
                        <?php } ?>

                        <?php if ($show_lead_title || $show_lead_intro || $show_lead_date || $show_lead_hits || $show_lead_cat || $show_lead_author) { ?>
                            
							<?php if ($lead_text_type == "news_on_image") { ?>
								<a href="<?php echo $item->link; ?>"><div class="link_on_image"></div></a>
							<?php } ?>
							
							<div class="item_description <?php echo $lead_text_type; ?>">

                                <!-- Show Category -->
                                <?php if ($show_lead_cat && !$lead_cat_top) { ?>
                                    <div class = "lead_category">
                                        <a href="<?php echo $item->categoryLink; ?>" class="lead_catid_<?php echo $item->catid; ?>">
                                            <?php echo $item->category_title; ?>
                                        </a>
                                    </div>
                                <?php } ?>

								<!-- Show Extra Field Before Title -->
								<?php if ($leading_show_field && $leading_field_position == "before_title") {
									if ($source == "category") { //Joomla Field
										$fields = FieldsHelper::getFields('com_content.article', $item, true);
										if (!empty($fields[$leading_field_number]->value)) {
											echo "<span class='leading_news_field'>{$leading_field_text} {$functions->trimText($fields[$leading_field_number]->value, $leading_field_character_limit, "char", "...")}</span>"; 
										}
									} else { //K2 Field
										$item_extra_fields = json_decode($item->extra_fields);
										if (!empty($item_extra_fields[$leading_field_number]->value)) {
											echo "<span class='leading_news_field'>{$leading_field_text} {$functions->trimText($item_extra_fields[$leading_field_number]->value, $leading_field_character_limit, "char", "...")}</span>"; 
										}
									} 
								} ?>
						
                                <!-- Show Title -->
                                <?php if ($show_lead_title) { ?>
                                    <a href="<?php echo $item->link; ?>" class="lead_title" itemprop="url" style="font-size: <?php echo $lead_title_size; ?>px; font-weight: <?php echo $lead_title_weight; ?>;"><?php echo $functions->trimText($item->title, $lead_title_limit, "char", "..."); ?></a>
                                <?php } ?>
								
								<!-- Show Extra Field After Title -->
								<?php if ($leading_show_field && $leading_field_position == "after_title") {
									if ($source == "category") { //Joomla Field
										$fields = FieldsHelper::getFields('com_content.article', $item, true);
										if (!empty($fields[$leading_field_number]->value)) {
											echo "<span class='leading_news_field'>{$leading_field_text} {$functions->trimText($fields[$leading_field_number]->value, $leading_field_character_limit, "char", "...")}</span>"; 
										}
									} else { //K2 Field
										$item_extra_fields = json_decode($item->extra_fields);
										if (!empty($item_extra_fields[$leading_field_number]->value)) {
											echo "<span class='leading_news_field'>{$leading_field_text} {$functions->trimText($item_extra_fields[$leading_field_number]->value, $leading_field_character_limit, "char", "...")}</span>"; 
										}
									} 
								} ?>

                                <!-- Show Text -->
                                <?php if ($show_lead_intro) { ?>
                                    <p class="lead_introtext"><?php echo $functions->trimText($item->introtext, $lead_introtext_limit, "char", "..."); ?></p>
                                <?php } ?>

								<!-- Show Read More -->
								<?php if ($lead_show_read_more) { ?>
									<a href="<?php echo $item->link; ?>" class="lead_read_more" style="color: <?php echo $lead_read_more_color; ?>; font-size: <?php echo $lead_read_more_font_size; ?>;"><?php echo $lead_read_more_text; ?></a>
								<?php } ?>

								<div class="lead_date_hits_author">
									<!-- Show Date -->
									<?php if ($show_lead_date) { ?>
										<div class="lead_date">
											<img class="lead_date_icon" src="<?php echo $lead_date_icon; ?>"/>
											<time datetime="<?php echo $item->publish_up ?>" itemprop="datePublished">
												<?php echo JHtml::_('date', $item->publish_up, JText::_("DATE_FORMAT_$show_lead_date")); ?>
											</time>
										</div>
									<?php } ?>

									<!-- Show Hits -->
									<?php if ($show_lead_hits) { ?>
									<div class="lead_hits">
										<img class="lead_hits_icon" src="<?php echo $lead_hits_icon; ?>"/>
										<meta itemprop="interactionCount" content="UserPageVisits:<?php echo $item->hits; ?>"><?php echo $item->hits; ?>
									</div>
									<?php } ?>
									
									<!-- Show Joomla Author -->
									<?php if ($show_lead_author && $source == "category") { ?>
										<?php if (isset($item->author) && $item->author !== "" || isset($item->created_by_alias) && $item->created_by_alias !== "") { ?>
											<div class="lead_auhor" itemprop="author" itemtype="http://schema.org/Person">
												<img class="lead_author_icon" src="<?php echo $lead_author_icon; ?>"/>
												<?php if (isset($item->author)) echo $item->author; else echo $item->created_by_alias; ?>
											</div>
										<?php }
									} ?>
									
									<!-- Show K2 Author -->
									<?php if ($show_lead_author && $source == "k2_category") { ?>
										<?php if (isset($item->created_by)) { ?>
											<div class="lead_auhor" itemprop="author" itemtype="http://schema.org/Person">
												<img class="lead_author_icon" src="<?php echo $lead_author_icon; ?>"/>
												<?php $author = JFactory::getUser($item->created_by);
												echo $author->name; ?>
											</div>
										<?php }
									} ?>
								</div>
                            </div>
							
                        <?php } ?>

                    </div>
                </div>

            <?php $lead_image_count += 1;
            } ?>

        </div>
    <?php } ?>

</div>

<style>
    #ruxin_news_<?php echo $module->id ?> .news-leading {
        width: <?php echo $lead_width; ?>;
    }
	
	<?php if ($lead_text_center) { ?>
	#ruxin_news_<?php echo $module->id ?> .news-leading .item_description, #ruxin_news_<?php echo $module->id ?> .news-leading .lead_category {
		text-align: center;
		margin: 0 auto;
	}
	<?php } ?>
</style>
