<?php
/**--------------------------------------
 * @package     ruxin_news - Ruxin News
 * @copyright   Copyright (C) 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 * ---------------------------------------**/

// no direct access
defined('_JEXEC') or die;

// Check K2 Exist
$db = JFactory::getDBO();
$db->setQuery('SELECT enabled FROM #__extensions WHERE name = ' . $db->quote('com_k2'));
$rs = $db->loadResult();
if ($rs) {
	require_once('k2_base.php');

	class K2ElementK2Tags extends K2Element
	{
		public function fetchElement($name, $value, &$node, $control_name)
		{
			$fieldName = (K2_JVERSION != '15') ? $name.'[]' : $control_name.'['.$name.'][]';

			$document = JFactory::getDocument();
			$document->addStyleSheet('https://cdn.jsdelivr.net/npm/select2@4.0.12/dist/css/select2.min.css');
			$document->addScript('https://cdn.jsdelivr.net/npm/select2@4.0.12/dist/js/select2.min.js');
			$document->addScriptDeclaration('
				$K2(document).ready(function() {
					if(typeof($K2(".k2TagsElement").chosen) == "function") {
						$K2(".k2TagsElement").chosen("destroy");
					}
					$K2(".k2TagsElement").select2({
						width : "300px",
						minimumInputLength : 2,
						ajax: {
							dataType : "json",
							url: "'.JURI::root(true).'/administrator/index.php?option=com_k2&view=item&task=tags&id=1",
							cache: "true",
							 data: function (params) {
								var queryParameters = {q: params.term};
								return queryParameters;
							 },
							 processResults: function (data) {
								var results = [];
								jQuery.each(data, function(index, value) {
									var row = {
										id : value.id,
										text : value.name
									};
									results.push(row);
								});
								return {results: results};
							 }

						}
					});
				});
			');

			$options = array();
			if (is_array($value) && count($value)) {
				$db = JFactory::getDbo();
				$query = "SELECT id AS value, name AS text FROM #__k2_tags WHERE id IN(".implode(',', $value).")";
				$db->setQuery($query);
				$options = $db->loadObjectList();
			}

			return JHTML::_('select.genericlist', $options, $fieldName, 'class="k2TagsElement" multiple="multiple" size="15"', 'value', 'text', $value);
		}
	}

	class JFormFieldK2Tags extends K2ElementK2Tags
	{
		public $type = 'k2tags';
	}

	class JElementK2Tags extends K2ElementK2Tags
	{
		public $_name = 'k2tags';
	}
}


