<?php
/**--------------------------------------
 * @package     mod_ruxin_bmi_calculator - Ruxin BMI Calculator
 * @copyright   Copyright (C) 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 * ---------------------------------------**/

defined('_JEXEC') or die;

$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::root().'modules/mod_ruxin_bmi_calculator/assets/css/ruxin_bmi_calculator.css');
if ($params->get('jquery', 0)) $doc->addscript(JURI::root().'modules/mod_ruxin_bmi_calculator/assets/js/jquery.min.js');

$width = $params->get('width', '500px');
$padding = $params->get('padding', '20px');
$radius = $params->get('radius', '8px');
$background_color = $params->get('background_color', '#fafafa');

$header_text = $params->get('header_text', 'BMI Calculator');
$fill_the_form_text = $params->get('fill_the_form_text', 'Fill in your weight and height');
$reset_text = $params->get('reset_text', 'Reset');
$change_unit_text = $params->get('change_unit_text', 'Change Unit');
$kg_weight_placeholder_text = $params->get('kg_weight_placeholder_text', 'Add weight in kg');
$cm_height_placeholder_text = $params->get('cm_height_placeholder_text', 'Add height in cm');
$feet_height_placeholder_text = $params->get('feet_height_placeholder_text', 'Feet');
$inch_height_placeholder_text = $params->get('inch_height_placeholder_text', 'Inches');
$calculate_text = $params->get('calculate_text', 'Calculate');
$your_bmi_text = $params->get('your_bmi_text', 'Your BMI is');
$health_is_wealth_text = $params->get('health_is_wealth_text', 'Health is wealth');
$you_are_healthy_text = $params->get('you_are_healthy_text', 'You are Healthy');
$you_are_underweight_text = $params->get('you_are_underweight_text', 'You are Underweight');
$you_are_overweight_text = $params->get('you_are_overweight_text', 'You are Overweight');
$you_are_obese_text = $params->get('you_are_obese_text', 'You are Obese');
$advice_text = $params->get('advice_text', 'Advice?');

$underweight_advice_link = $params->get('underweight_advice_link', 'https://healthyeating.sfgate.com/recommendations-someone-underweight-2079.html');
$overweight_advice_link = $params->get('overweight_advice_link', 'https://www.sophiederam.com/en/blog/eating-behavior/tips-for-overweight-people/');
$obese_advice_link = $params->get('obese_advice_link', 'https://www.nhs.uk/conditions/obesity/');

?>

<div id="ruxin_bmi_calculator" class="ruxin_bmi_calculator<?php echo $module->id; ?>">
	<div id="bmi" class="bmi<?php echo $module->id; ?>">
		<h2><?php echo $header_text; ?></h2>
		<p><?php echo $fill_the_form_text; ?><button type="button" class="bmi-change-unit new bmi-btn bmi-btn-secondary"><?php echo $change_unit_text; ?></button><button type="button" class="bmi-reset new bmi-btn bmi-btn-secondary"><?php echo $reset_text; ?></button></p>

		<div class="bmi-input-group bmi-mb-3">
			<input type="number" class="bmi-weight-kg bmi-form-control" placeholder="<?php echo $kg_weight_placeholder_text; ?>">
		</div>

		<form class="inch-form bmi-hidden">
			<div class="bmi-row bmi-mb-3">
				<div class="bmi-col">
					<input type="number" class="bmi-height-feet bmi-hidden bmi-form-control" placeholder="<?php echo $feet_height_placeholder_text; ?>">
				</div>
				<div class="bmi-col">
					<input type="number" class="bmi-height-inch bmi-hidden bmi-form-control" placeholder="<?php echo $inch_height_placeholder_text; ?>">
				</div>
			</div>
		</form>

		<div class="bmi-input-group bmi-mb-3">
			<input type="number" class="bmi-height-cm bmi-form-control" placeholder="<?php echo $cm_height_placeholder_text; ?>" aria-label="Recipient's username"
				   aria-describedby="basic-addon2" >
		</div>
		<button type="button" class="bmi-calculate-inch bmi-hidden bmi-btn bmi-btn-secondary bmi-btn-lg bmi-btn-block"><?php echo $calculate_text; ?></button>
		<button type="button" class="bmi-calculate-cm bmi-btn bmi-btn-secondary bmi-btn-lg bmi-btn-block"><?php echo $calculate_text; ?></button>
		<hr>
		<p class="bmi-result-label"><?php echo $your_bmi_text; ?></p>
		<h3 class="bmi-result">0</h3>
		<hr>
		<p class='health-default'><?php echo $health_is_wealth_text; ?></p>
		<p class='underweight bmi-hidden'><?php echo $you_are_underweight_text; ?></p>
		<p class='health bmi-hidden'><?php echo $you_are_healthy_text; ?></p>
		<p class='overweight bmi-hidden'><?php echo $you_are_overweight_text; ?></p>
		<p class='obese bmi-hidden'><?php echo $you_are_obese_text; ?></p>

		<a href=""></a>
		<a target="_blank" href="<?php echo $underweight_advice_link; ?>" class='advice advice-underweight bmi-hidden'><?php echo $advice_text; ?></a>
		<a target="_blank" href="<?php echo $overweight_advice_link; ?>" class='advice advice-overweight bmi-hidden'><?php echo $advice_text; ?></a>
		<a target="_blank" href="<?php echo $obese_advice_link; ?>" class='advice advice-obese bmi-hidden'><?php echo $advice_text; ?></a>
	</div>
</div>

<script>

	// Change Unit Button
	var unit = 'cm';
	jQuery(".bmi-change-unit").click(function(){

		if(unit == 'cm') {
			jQuery('.inch-form, .bmi-height-feet, .bmi-height-inch, .bmi-calculate-inch').removeClass('bmi-hidden');
			jQuery('.bmi-height-cm, .bmi-calculate-cm').addClass('bmi-hidden');
			unit = 'inch';
		} else {
			jQuery('.inch-form, .bmi-height-feet, .bmi-height-inch, .bmi-calculate-inch').addClass('bmi-hidden');
			jQuery('.bmi-height-cm, .bmi-calculate-cm').removeClass('bmi-hidden');
			unit = 'cm';
		}

	});

	// Reset Button
	jQuery(".bmi-reset").click(function(){
		jQuery('.bmi-weight-kg, .bmi-height-cm, .bmi-height-feet, .bmi-height-inch').val("");
		jQuery('.bmi-result').text("0");
		jQuery('.advice, .underweight, .health, .overweight, .obese').addClass('bmi-hidden');
		jQuery('.health-default').removeClass('bmi-hidden');
	});

	// Calculate Button (cm)
	jQuery(".bmi-calculate-cm").click(function() {

		var result = 0;
		var weight = parseFloat(jQuery('.bmi-weight-kg').val());
		var height = parseFloat(jQuery('.bmi-height-cm').val())/100;

		result = parseFloat(weight / (height * height)).toFixed(1);

		if (result != "NaN") {

			jQuery('.advice, .health-default, .underweight, .health, .overweight, .obese').addClass('bmi-hidden');
			jQuery('.bmi-result').text(result);

			if (result > 0 && result < 18.5) { // UnderWeight
				jQuery('.advice-underweight, .underweight').removeClass('bmi-hidden');
			} else if (result >= 18.5 && result <= 24.9) { // Normal
				jQuery('.health').removeClass('bmi-hidden');
			} else if (result >= 25.0 && result <= 29.9) { // OverWeight
				jQuery('.advice-overweight, .overweight').removeClass('bmi-hidden');
			} else if (result > 29.9) { // Obese
				jQuery('.advice-obese, .obese').removeClass('bmi-hidden');
			}

		}

	});

	// Calculate Button (inch & feet)
	jQuery(".bmi-calculate-inch").click(function() {

		var result = 0;
		var weight = parseFloat(jQuery('.bmi-weight-kg').val());
		var newheight = parseFloat((Number(jQuery('.bmi-height-feet').val() * 12) + Number(jQuery('.bmi-height-inch').val())) * 2.54)/100;

		result = parseFloat(weight / (newheight * newheight)).toFixed(1);

		if (result != "NaN" && result != "Infinity") {

			jQuery('.advice, .health-default, .underweight, .health, .overweight, .obese').addClass('bmi-hidden');
			jQuery('.bmi-result').text(result);

			if (result > 0 && result < 18.5) { // UnderWeight
				jQuery('.advice-underweight, .underweight').removeClass('bmi-hidden');
			} else if (result >= 18.5 && result <= 24.9) { // Normal
				jQuery('.health').removeClass('bmi-hidden');
			} else if (result >= 25.0 && result <= 29.9) { // OverWeight
				jQuery('.advice-overweight, .overweight').removeClass('bmi-hidden');
			} else if (result > 29.9) { // Obese
				jQuery('.advice-obese, .obese').removeClass('bmi-hidden');
			}

		}

	});

</script>

<style>
	.ruxin_bmi_calculator<?php echo $module->id; ?> {
		width: <?php echo $width; ?>;
		padding: <?php echo $padding; ?>;
		background-color: <?php echo $background_color; ?>;
		border-radius: <?php echo $radius; ?>;
	}
</style>